//
//  WDDeviceModel.h
//  SmartWare
//
//  Created by Clark Jackson on 1/19/11.
//  Copyright 2011 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class WDVolumeModel;



// Note: the VCD and mass storage are treated as separate devices but they point to each other (the connection can only be made by WDDM)
// Note: source or destination is specified per volume not device
@interface WDDeviceModel : NSObject
{
    // Available from OS
    NSString* name;
    NSString* wholeMedia; // 4 values possible, IODVDMedia, IOCDMedia, IOMassStorageMedia, IOMedia (everything else: flash drive, floppy, etc.)
    NSString* bsdName;
    // target can be a WDVolumeModel (most often, hopefully) or it can be a WDDeviceModel (if a device has no volumes it can still be the target)
    id targetObject; // only if it has it, if it has it it is the target device or volume (only one at a time), method in EcoSystemController to discover
    WDVolumeModel* selectedVolume; // every DeviceModel will have a selected volume
    WDVolumeModel* bootVolume; // only if it has it, if it has it it is the boot device (only one at a time), method in EcoSystemController to discover
    WDVolumeModel* launchVolume; // only if it has it, if it has it it is the launch device (only one at a time), method in EcoSystemController to discover
    WDVolumeModel* sourceVolume; // only if it has it, if it has it it is the source device (only one at a time), method in EcoSystemController to discover
    BOOL isApollo;
    UInt16 pid;
    NSMutableDictionary* volumes; // contains WDVolumeModel's keyed by bsdNodeName
    
    // Available from WDDM
    NSString* serialNumber;
    WDDeviceModel* associatedDevice; // when a mass storage device has a VCD this instance variable points to each other, otherwise it is nil
    UInt16 firmwareVersion;
    unsigned long long capacityBytes; // UInt64
    
    // NAS
    BOOL isNAS;
    NSString* UUID; // "73656761-7465-7375-636b-0090a9f606bc";
    NSString* hostName; // "kathleenlive3.local.";
    NSString* ipAddress; // "172.25.102.4";
    NSString* model; // AP1NC;
    NSString* friendlyNASName; // kathleenlive3;
    NSString* serviceDomain; // "local.";
    NSString* serviceType; // "_http._tcp.";
    NSDictionary* storageUseage;
    NSDictionary* systemInformation;
    NSDictionary* systemState;
    NSDictionary* firmwareUpdate;
    NSDictionary* firmwareInformation;

    
}

@property (readwrite, copy) NSString* name, *wholeMedia, *bsdName, *serialNumber;
@property (readwrite, retain) WDVolumeModel* selectedVolume, *bootVolume, *launchVolume, *sourceVolume; // notice assign here
@property (readwrite, retain) id targetObject; // notice assign here
@property (readwrite, retain) WDDeviceModel* associatedDevice;
@property (readwrite, retain) NSMutableDictionary* volumes;
@property (readwrite, assign) BOOL isApollo, isNAS;
@property (readwrite, assign) unsigned long long capacityBytes;
@property (readwrite, assign) UInt16 firmwareVersion, pid;
@property (readwrite, copy) NSString* UUID, *hostName, *ipAddress, *model, *friendlyNASName, *serviceDomain, *serviceType;
@property (readwrite, retain) NSDictionary* storageUseage, *systemInformation, *systemState, *firmwareUpdate, *firmwareInformation;

- (NSMutableArray*) volumeNames;
- (WDVolumeModel*) volumeByName:(NSString*)volName;
- (NSString*) description;
- (NSString*) pidAsHexString;
- (NSString*) pidAsDecString;

@end
